
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="rotisserie_chickens", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="steaks")

    # Define the objective function
    model.setObjective(4 * x1 + 9 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(22 * x1 + 14 * x2 >= 77)
    model.addConstr(8 * x1 + 4 * x2 >= 75)
    model.addConstr(26 * x1 + 20 * x2 >= 43)
    model.addConstr(x1 - 5 * x2 >= 0)
    model.addConstr(22 * x1 + 14 * x2 <= 174)
    model.addConstr(8 * x1 + 4 * x2 <= 218)
    model.addConstr(26 * x1 + 20 * x2 <= 64)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Rotisserie chickens: {x1.varValue}")
        print(f"Steaks: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
