
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize_Work_Hours")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Mary
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by Jean
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by George


    # Set objective function
    model.setObjective(1.7 * x0 + 9.18 * x1 + 6.03 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(16 * x0 + 13 * x1 >= 36, "c0")
    model.addConstr(13 * x1 + 5 * x2 >= 16, "c1")
    model.addConstr(16 * x0 + 13 * x1 + 5 * x2 >= 21, "c2")
    model.addConstr(11 * x1 + 16 * x2 >= 19, "c3")
    model.addConstr(11 * x0 + 16 * x2 >= 21, "c4")
    model.addConstr(11 * x0 + 7 * x1 + 16 * x2 >= 21, "c5")
    model.addConstr(1 * x0 + 7 * x2 >= 24, "c6")
    model.addConstr(1 * x0 + 6 * x1 >= 47, "c7")
    model.addConstr(6 * x1 + 7 * x2 >= 43, "c8")
    model.addConstr(1 * x0 + 6 * x1 + 7 * x2 >= 43, "c9")
    model.addConstr(16 * x0 + 5 * x2 <= 107, "c10")
    model.addConstr(16 * x0 + 13 * x1 + 5 * x2 <= 108, "c11")
    model.addConstr(11 * x0 + 16 * x2 <= 40, "c12")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
