
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Mary", lb=0)  # No upper bound for hours worked
x1 = m.addVar(name="hours_worked_by_Jean", lb=0)
x2 = m.addVar(name="hours_worked_by_George", lb=0)

# Define the objective function
m.setObjective(1.7*x0 + 9.18*x1 + 6.03*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16*x0 <= 121)
m.addConstr(11*x0 <= 107)
m.addConstr(x0 <= 166)
m.addConstr(13*x1 <= 121)
m.addConstr(7*x1 <= 107)
m.addConstr(6*x1 <= 166)
m.addConstr(5*x2 <= 121)
m.addConstr(16*x2 <= 107)
m.addConstr(7*x2 <= 166)
m.addConstr(16*x0 + 13*x1 >= 36)
m.addConstr(13*x1 + 5*x2 >= 16)
m.addConstr(16*x0 + 13*x1 + 5*x2 >= 21)
m.addConstr(16*x0 + 13*x1 + 5*x2 >= 21)
m.addConstr(7*x1 + 16*x2 >= 19)
m.addConstr(11*x0 + 16*x2 >= 21)
m.addConstr(11*x0 + 7*x1 + 16*x2 >= 21)
m.addConstr(x0 + 7*x2 >= 24)
m.addConstr(x0 + 6*x1 >= 47)
m.addConstr(6*x1 + 7*x2 >= 43)
m.addConstr(x0 + 6*x1 + 7*x2 >= 43)
m.addConstr(16*x0 + 5*x2 <= 107)
m.addConstr(16*x0 + 13*x1 + 5*x2 <= 108)
m.addConstr(11*x0 + 16*x2 <= 40)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Mary: {x0.varValue}")
    print(f"Hours worked by Jean: {x1.varValue}")
    print(f"Hours worked by George: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
