
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("minimize_work_hours")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="George_hours")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bill_hours")
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Hank_hours")


    # Set objective function
    model.setObjective(9*x0 + 5*x1 + 9*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1*x0 + 4*x2 >= 19, "c1")
    model.addConstr(1*x0 + 3*x1 >= 24, "c2")
    model.addConstr(1*x0 + 3*x1 + 4*x2 >= 24, "c3")
    model.addConstr(3*x0 + 1*x2 >= 14, "c4")
    model.addConstr(3*x0 + 4*x1 >= 6, "c5")
    model.addConstr(4*x1 + 1*x2 >= 6, "c6")
    model.addConstr(3*x0 + 4*x1 + 1*x2 >= 6, "c7")
    model.addConstr(-8*x1 + 3*x2 >= 0, "c8")
    model.addConstr(1*x0 + 4*x2 <= 39, "c9")
    model.addConstr(3*x0 + 1*x2 <= 53, "c10")
    model.addConstr(3*x0 + 4*x1 + 1*x2 <= 38, "c11")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('George Hours:', x0.x)
        print('Bill Hours:', x1.x)
        print('Hank Hours:', x2.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
