
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by George
x1 = m.addVar(name="x1", lb=0)  # hours worked by Bill
x2 = m.addVar(name="x2", lb=0)  # hours worked by Hank

# Objective function
m.setObjective(9 * x0 + 5 * x1 + 9 * x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(x0 + 4 * x2 >= 19)
m.addConstr(x0 + 3 * x1 >= 24)
m.addConstr(x0 + 3 * x1 + 4 * x2 >= 24)
m.addConstr(3 * x0 + x2 >= 14)
m.addConstr(3 * x0 + 4 * x1 >= 6)
m.addConstr(4 * x1 + x2 >= 6)
m.addConstr(3 * x0 + 4 * x1 + x2 >= 6)
m.addConstr(-8 * x1 + 3 * x2 >= 0)
m.addConstr(x0 + 4 * x2 <= 39)
m.addConstr(3 * x0 + x2 <= 53)
m.addConstr(3 * x0 + 4 * x1 + x2 <= 38)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by George: ", x0.varValue)
    print("Hours worked by Bill: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
else:
    print("The model is infeasible")
