
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
packs_of_napkins = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_napkins")
dish_soap_bottles = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap_bottles")
cookies = m.addVar(vtype=gp.GRB.INTEGER, name="cookies")


# Set objective function
m.setObjective(5*lightbulbs + 2*packs_of_napkins + 9*dish_soap_bottles + 9*cookies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6.79*lightbulbs + 11.82*dish_soap_bottles + 9.22*cookies >= 106)
m.addConstr(6.79*lightbulbs + 6.59*packs_of_napkins + 9.22*cookies >= 106)
m.addConstr(6.79*lightbulbs + 6.59*packs_of_napkins + 11.82*dish_soap_bottles >= 106)
m.addConstr(6.79*lightbulbs + 11.82*dish_soap_bottles + 9.22*cookies >= 79)
m.addConstr(6.79*lightbulbs + 6.59*packs_of_napkins + 9.22*cookies >= 79)
m.addConstr(6.79*lightbulbs + 6.59*packs_of_napkins + 11.82*dish_soap_bottles >= 79)
m.addConstr(6.79*lightbulbs + 11.82*dish_soap_bottles + 9.22*cookies >= 145)
m.addConstr(6.79*lightbulbs + 6.59*packs_of_napkins + 9.22*cookies >= 145)
m.addConstr(6.79*lightbulbs + 6.59*packs_of_napkins + 11.82*dish_soap_bottles >= 145)
m.addConstr(14.05*lightbulbs + 11.8*packs_of_napkins <= 144)
m.addConstr(14.05*lightbulbs + 14.52*dish_soap_bottles <= 104)
m.addConstr(11.8*packs_of_napkins + 0.93*cookies <= 238)
m.addConstr(14.52*dish_soap_bottles + 0.93*cookies <= 260)
m.addConstr(14.05*lightbulbs + 11.8*packs_of_napkins + 14.52*dish_soap_bottles <= 195)
m.addConstr(14.05*lightbulbs + 11.8*packs_of_napkins + 14.52*dish_soap_bottles + 0.93*cookies <= 195)
m.addConstr(6.79*lightbulbs + 6.59*packs_of_napkins <= 458)
m.addConstr(6.79*lightbulbs + 9.22*cookies <= 521)
m.addConstr(6.79*lightbulbs + 11.82*dish_soap_bottles <= 505)
m.addConstr(6.79*lightbulbs + 6.59*packs_of_napkins + 11.82*dish_soap_bottles + 9.22*cookies <= 505)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

