
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="lightbulbs", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="packs of napkins", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="dish soap bottles", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="cookies", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(5 * x1 + 2 * x2 + 9 * x3 + 9 * x4, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6.79 * x1 + 11.82 * x3 + 9.22 * x4 >= 106)
m.addConstr(6.79 * x1 + 6.59 * x2 + 9.22 * x4 >= 106)
m.addConstr(6.79 * x1 + 6.59 * x2 + 11.82 * x3 >= 106)
m.addConstr(6.79 * x1 + 11.82 * x3 + 9.22 * x4 >= 79)
m.addConstr(6.79 * x1 + 6.59 * x2 + 9.22 * x4 >= 79)
m.addConstr(6.79 * x1 + 6.59 * x2 + 11.82 * x3 >= 79)
m.addConstr(6.79 * x1 + 11.82 * x3 + 9.22 * x4 >= 145)
m.addConstr(6.79 * x1 + 6.59 * x2 + 9.22 * x4 >= 145)
m.addConstr(6.79 * x1 + 6.59 * x2 + 11.82 * x3 >= 145)
m.addConstr(14.05 * x1 + 11.8 * x2 <= 144)
m.addConstr(14.05 * x1 + 14.52 * x3 <= 104)
m.addConstr(11.8 * x2 + 0.93 * x4 <= 238)
m.addConstr(14.52 * x3 + 0.93 * x4 <= 260)
m.addConstr(14.05 * x1 + 11.8 * x2 + 14.52 * x3 <= 195)
m.addConstr(14.05 * x1 + 11.8 * x2 + 14.52 * x3 + 0.93 * x4 <= 195)
m.addConstr(6.79 * x1 + 6.59 * x2 <= 458)
m.addConstr(6.79 * x1 + 9.22 * x4 <= 521)
m.addConstr(6.79 * x1 + 11.82 * x3 <= 505)
m.addConstr(6.79 * x1 + 6.59 * x2 + 11.82 * x3 + 9.22 * x4 <= 505)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Lightbulbs: ", x1.varValue)
    print("Packs of napkins: ", x2.varValue)
    print("Dish soap bottles: ", x3.varValue)
    print("Cookies: ", x4.varValue)
else:
    print("The model is infeasible")
