
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("minimize_food_cost")

    # Create variables
    cheeseburgers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cheeseburgers")
    hot_dogs = m.addVar(lb=0, vtype=GRB.INTEGER, name="hot_dogs")


    # Set objective function
    m.setObjective(3 * cheeseburgers + 6 * hot_dogs, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5 * cheeseburgers + 4 * hot_dogs >= 11, "fat_lower_bound")
    m.addConstr(2 * cheeseburgers + 3 * hot_dogs >= 8, "calcium_lower_bound")
    m.addConstr(10 * cheeseburgers - 3 * hot_dogs >= 0, "cheeseburger_hot_dog_ratio")
    m.addConstr(5 * cheeseburgers + 4 * hot_dogs <= 40, "fat_upper_bound")  # Added upper bound on fat
    m.addConstr(2 * cheeseburgers + 3 * hot_dogs <= 13, "calcium_upper_bound") # Added upper bound on calcium


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal solution found: cheeseburgers = {cheeseburgers.x}, hot dogs = {hot_dogs.x}")
        print(f"Objective value: {m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
