
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="cheeseburgers")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="hot_dogs")

# Define the objective function
m.setObjective(3*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 >= 11, "fat_min")
m.addConstr(2*x1 + 3*x2 >= 8, "calcium_min")
m.addConstr(10*x1 - 3*x2 >= 0, "custom_constraint")
m.addConstr(5*x1 + 4*x2 <= 40, "fat_max")
m.addConstr(2*x1 + 3*x2 <= 13, "calcium_max")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cheeseburgers: {x1.x}")
    print(f"Hot dogs: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
