
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="cheeseburgers", lb=0)  # cheeseburgers can be fractional
x2 = m.addVar(name="hot dogs", lb=0, integrality=gurobi.GRB.INTEGER)  # hot dogs must be an integer

# Objective function: minimize 3*cheeseburgers + 6*hot dogs
m.setObjective(3*x1 + 6*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x1 + 4*x2 >= 11, name="fat_requirement")
m.addConstr(2*x1 + 3*x2 >= 8, name="calcium_requirement")
m.addConstr(10*x1 - 3*x2 >= 0, name="cheeseburgers_vs_hotdogs")
m.addConstr(5*x1 + 4*x2 <= 40, name="fat_limit")
m.addConstr(2*x1 + 3*x2 <= 13, name="calcium_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Cheeseburgers: ", x1.varValue)
    print("Hot dogs: ", x2.varValue)
else:
    print("The model is infeasible")
