
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of potassium
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # milligrams of calcium
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin B4
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # grams of protein
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x4")  # milligrams of zinc


# Set objective function
m.setObjective(4.05*x0**2 + 7.19*x0*x1 + 8.62*x0*x2 + 9.82*x0*x3 + 4.28*x0*x4 + 5.76*x1*x2 + 3.61*x1*x3 + 5.63*x1*x4 + 3.17*x2**2 + 8.57*x2*x3 + 8.89*x2*x4 + 1.89*x0 + 4.34*x2 + 4.89*x3 + 1.31*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14*x0 + 4*x1 + 7*x2 + 12*x3 + x4 <= 200)
m.addConstr(12*x0 + 2*x1 + 12*x2 + 5*x3 + x4 <= 81)
m.addConstr(14*x0 + x1 + 3*x2 + 7*x3 + 9*x4 <= 163)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

