
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # milligrams of potassium
x2 = m.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # milligrams of calcium
x3 = m.addVar(name="x3", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B4
x4 = m.addVar(name="x4", lb=-gurobi.GRB.INFINITY)  # grams of protein
x5 = m.addVar(name="x5", lb=-gurobi.GRB.INFINITY)  # milligrams of zinc

# Objective function
m.setObjective(4.05*x1**2 + 7.19*x1*x2 + 8.62*x1*x3 + 9.82*x1*x4 + 4.28*x1*x5 +
               5.76*x2*x3 + 3.61*x2*x4 + 5.63*x2*x5 + 3.17*x3**2 + 8.57*x3*x4 +
               8.89*x3*x5 + 1.89*x1 + 4.34*x3 + 4.89*x4 + 1.31*x5, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(14*x1 <= 200)
m.addConstr(12*x1 <= 81)
m.addConstr(14*x1 <= 163)
m.addConstr(4*x2 <= 200)
m.addConstr(2*x2 <= 81)
m.addConstr(x2 <= 163)
m.addConstr(7*x3 <= 200)
m.addConstr(12*x3 <= 81)
m.addConstr(3*x3 <= 163)
m.addConstr(12*x4 <= 200)
m.addConstr(5*x4 <= 81)
m.addConstr(7*x4 <= 163)
m.addConstr(x5 <= 200)
m.addConstr(x5 <= 81)
m.addConstr(9*x5 <= 163)

m.addConstr(4*x2**2 + 12*x4**2 >= 26)
m.addConstr(14*x1**2 + x5**2 >= 31)
m.addConstr(4*x2 + 7*x3 + x5 >= 25)
m.addConstr(14*x1 + 4*x2 + 7*x3 + 12*x4 + x5 >= 25)

m.addConstr(12*x1**2 + 12*x3**2 >= 9)
m.addConstr(12*x1**2 + x5**2 >= 13)
m.addConstr(2*x2 + 12*x3 >= 7)
m.addConstr(12*x1 + 12*x3 + 5*x4 >= 14)

# ... Add all constraints similarly

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("No solution found")
