
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    ringo_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Ringo
    jean_hours = m.addVar(vtype=gp.GRB.INTEGER, name="x1")  # hours worked by Jean


    # Set objective function
    m.setObjective(8 * ringo_hours + 4 * jean_hours, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4 * ringo_hours + 3 * jean_hours >= 10, "c0")
    m.addConstr(3 * ringo_hours + 1 * jean_hours >= 9, "c1")
    m.addConstr(1 * ringo_hours + 3 * jean_hours >= 16, "c2")
    m.addConstr(3 * ringo_hours + 2 * jean_hours >= 7, "c3")
    m.addConstr(5 * ringo_hours + 1 * jean_hours >= 7, "c4")
    m.addConstr(-9 * ringo_hours + 5 * jean_hours >= 0, "c5")
    m.addConstr(4 * ringo_hours + 3 * jean_hours <= 27, "c6")
    m.addConstr(3 * ringo_hours + 1 * jean_hours <= 10, "c7")
    m.addConstr(1 * ringo_hours + 3 * jean_hours <= 30, "c8")
    m.addConstr(3 * ringo_hours + 2 * jean_hours <= 26, "c9")
    m.addConstr(5 * ringo_hours + 1 * jean_hours <= 19, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status %d" % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

