
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")

# Set the objective function
m.setObjective(8*x1 + 4*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(4*x1 + 3*x2 >= 10, "likelihood_to_quit_index_min")
m.addConstr(4*x1 + 3*x2 <= 27, "likelihood_to_quit_index_max")
m.addConstr(3*x1 + 1*x2 >= 9, "organization_score_min")
m.addConstr(3*x1 + 1*x2 <= 10, "organization_score_max")
m.addConstr(1*x1 + 3*x2 >= 16, "paperwork_competence_rating_min")
m.addConstr(1*x1 + 3*x2 <= 30, "paperwork_competence_rating_max")
m.addConstr(3*x1 + 2*x2 >= 7, "work_quality_rating_min")
m.addConstr(3*x1 + 2*x2 <= 26, "work_quality_rating_max")
m.addConstr(5*x1 + 1*x2 >= 7, "computer_competence_rating_min")
m.addConstr(5*x1 + 1*x2 <= 19, "computer_competence_rating_max")
m.addConstr(-9*x1 + 5*x2 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Ringo: {x1.x}")
    print(f"Hours worked by Jean: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
