
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x1 = m.addVar(name="hours_worked_by_Ringo", lb=0)  # No upper bound given
x2 = m.addVar(name="hours_worked_by_Jean", lb=0, type=gp.GRB.INTEGER)

# Objective function
m.setObjective(8 * x1 + 4 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(4 * x1 >= 4)
m.addConstr(3 * x1 >= 3)
m.addConstr(x1 >= 1)
m.addConstr(3 * x1 >= 3)
m.addConstr(5 * x1 >= 5)

m.addConstr(3 * x2 >= 3)
m.addConstr(x2 >= 1)
m.addConstr(3 * x2 >= 3)
m.addConstr(2 * x2 >= 2)
m.addConstr(x2 >= 1)

m.addConstr(4 * x1 + 3 * x2 >= 10)
m.addConstr(3 * x1 + x2 >= 9)
m.addConstr(x1 + 3 * x2 >= 16)
m.addConstr(3 * x1 + 2 * x2 >= 7)
m.addConstr(5 * x1 + x2 >= 7)

m.addConstr(-9 * x1 + 5 * x2 >= 0)

m.addConstr(4 * x1 + 3 * x2 <= 27)
m.addConstr(3 * x1 + x2 <= 10)
m.addConstr(x1 + 3 * x2 <= 30)
m.addConstr(3 * x1 + 2 * x2 <= 26)
m.addConstr(5 * x1 + x2 <= 19)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Ringo: {x1.varValue}")
    print(f"Hours worked by Jean: {x2.varValue}")
else:
    print("No optimal solution found.")
