
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
kiwis = m.addVar(name="kiwis")
eggs = m.addVar(name="eggs")
cherry_pies = m.addVar(name="cherry_pies")


# Set objective function
m.setObjective(3*kiwis*eggs + 2*kiwis + 4*eggs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*kiwis + 6*eggs <= 172, "c1")
m.addConstr(11*kiwis + 3*cherry_pies <= 141, "c2")
m.addConstr(11*kiwis + 6*eggs + 3*cherry_pies <= 141, "c3")
m.addConstr(5*eggs + 7*cherry_pies <= 82, "c4")
m.addConstr(kiwis**2 + eggs**2 <= 83, "c5")  # Note: Non-linear constraint
m.addConstr(kiwis + eggs + cherry_pies <= 83, "c6")
m.addConstr(4*kiwis**2 + 9*eggs**2 <= 84, "c7") # Note: Non-linear constraint
m.addConstr(4*kiwis**2 + 9*eggs**2 + 3*cherry_pies**2 <= 175, "c8") # Note: Non-linear constraint
m.addConstr(4*kiwis + 9*eggs + 3*cherry_pies <= 175, "c9")


# Non-negativity constraints are added implicitly by gurobi for variables created with m.addVar()


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('kiwis:', kiwis.x)
    print('eggs:', eggs.x)
    print('cherry_pies:', cherry_pies.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

