
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    kiwis = model.addVar(name="kiwis", lb=0)
    eggs = model.addVar(name="eggs", lb=0)
    cherry_pies = model.addVar(name="cherry_pies", lb=0)

    # Objective function
    model.setObjective(3 * kiwis * eggs + 2 * kiwis + 4 * eggs, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(11 * kiwis + 6 * eggs <= 172)
    model.addConstr(11 * kiwis + 3 * cherry_pies <= 141)
    model.addConstr(11 * kiwis + 6 * eggs + 3 * cherry_pies <= 141)
    model.addConstr(5 * eggs + 7 * cherry_pies <= 82)
    model.addConstr(kiwis**2 + eggs**2 <= 83)
    model.addConstr(kiwis + eggs + cherry_pies <= 83)
    model.addConstr(kiwis**2 + eggs**2 <= 84)
    model.addConstr(kiwis**2 + eggs**2 + cherry_pies**2 <= 175)
    model.addConstr(4 * kiwis + 9 * eggs + 3 * cherry_pies <= 175)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Kiwis: ", kiwis.varValue)
        print("Eggs: ", eggs.varValue)
        print("Cherry Pies: ", cherry_pies.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
