
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_work_hours")

# Create variables
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")


# Set objective
m.setObjective(3.05 * hank + 6.55 * peggy + 8.67 * dale + 6.52 * john + 7.24 * ringo + 4.62 * bobby, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(28 * hank + 4 * bobby >= 48)
m.addConstr(28 * hank + 11 * john >= 26)
m.addConstr(27 * dale + 11 * john >= 34)
m.addConstr(27 * dale + 10 * ringo >= 49)
m.addConstr(11 * john + 4 * bobby >= 38)
m.addConstr(28 * hank + 10 * ringo >= 46)
m.addConstr(25 * peggy + 11 * john >= 62)
m.addConstr(25 * peggy + 27 * dale >= 29)
m.addConstr(25 * peggy + 4 * bobby >= 29)
m.addConstr(28 * hank + 25 * peggy + 27 * dale + 11 * john + 10 * ringo + 4 * bobby >= 29)
m.addConstr(1 * peggy + 20 * john >= 99)
m.addConstr(1 * peggy + 6 * dale >= 71)
m.addConstr(16 * hank + 20 * john >= 63)
m.addConstr(20 * john + 9 * bobby >= 70)
m.addConstr(7 * ringo + 9 * bobby >= 39)
m.addConstr(1 * peggy + 7 * ringo >= 101)
m.addConstr(16 * hank + 1 * peggy + 6 * dale + 20 * john + 7 * ringo + 9 * bobby >= 101)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

