
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables
x1 = m.addVar(name="hours_worked_by_Hank")
x2 = m.addVar(name="hours_worked_by_Peggy")
x3 = m.addVar(name="hours_worked_by_Dale")
x4 = m.addVar(name="hours_worked_by_John")
x5 = m.addVar(name="hours_worked_by_Ringo")
x6 = m.addVar(name="hours_worked_by_Bobby")

# Objective function: Minimize the total hours worked (placeholder)
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6, GRB.MINIMIZE)

# Constraints
m.addConstr(-7*x4 + 4*x5 >= 0, name="constraint_1")
m.addConstr(-8*x2 + 7*x6 >= 0, name="constraint_2")
m.addConstr(-4*x2 + x3 + 10*x5 >= 0, name="constraint_3")

# Add more constraints here based on the problem description

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

