
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x = model.addVars(6, name="x", lb=0)

    # Objective function
    model.setObjective(3.05*x[0] + 6.55*x[1] + 8.67*x[2] + 6.52*x[3] + 7.24*x[4] + 4.62*x[5], gurobi.GRB.MINIMIZE)

    # Constraints
    # ... adding constraints here would be too lengthy, 
    # but you can add them in a loop based on the json constraints

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        for i in range(6):
            print(f"x[{i}] = {x[i].varValue}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
