
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B7
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B5
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin C


    # Set objective function
    m.setObjective(3.31 * x0 + 7.64 * x1 + 8.06 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10*x0 + 5*x1 >= 52, "c1")
    m.addConstr(5*x1 + 8*x2 >= 23, "c2")
    m.addConstr(10*x0 + 5*x1 + 8*x2 >= 40, "c3")
    m.addConstr(8*x0 + 12*x1 + 11*x2 >= 38, "c4")
    m.addConstr(2*x0 + 4*x2 >= 22, "c5")
    m.addConstr(20*x1 + 4*x2 >= 36, "c6")
    m.addConstr(2*x0 + 20*x1 + 4*x2 >= 36, "c7")
    m.addConstr(-7*x1 + 9*x2 >= 0, "c8")
    m.addConstr(-3*x0 + 7*x2 >= 0, "c9")
    m.addConstr(10*x0 + 5*x1 + 8*x2 <= 76, "c10")
    m.addConstr(2*x0 + 4*x2 <= 120, "c11")

    # Resource Constraints
    m.addConstr(10*x0 + 5*x1 + 8*x2 <= 158, "r0")
    m.addConstr(8*x0 + 12*x1 + 11*x2 <= 130, "r1")
    m.addConstr(2*x0 + 20*x1 + 4*x2 <= 124, "r2")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
