
import gurobi

def optimize_vitamins():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin B7
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B5
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin C

    # Define the objective function
    model.setObjective(3.31 * x0 + 7.64 * x1 + 8.06 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(10 * x0 + 5 * x1 + 8 * x2 >= 52)  # digestive support index
    model.addConstr(5 * x1 + 8 * x2 >= 23)  # digestive support index from B5 and C
    model.addConstr(8 * x0 + 12 * x1 + 11 * x2 >= 38)  # energy stability index
    model.addConstr(12 * x1 + 11 * x2 >= 38)  # energy stability index from B5 and C
    model.addConstr(2 * x0 + 4 * x2 >= 22)  # immune support index from B7 and C
    model.addConstr(20 * x1 + 4 * x2 >= 36)  # immune support index from B5 and C
    model.addConstr(2 * x0 + 20 * x1 + 4 * x2 >= 36)  # immune support index from B7, B5, and C
    model.addConstr(-7 * x1 + 9 * x2 >= 0)
    model.addConstr(-3 * x0 + 7 * x2 >= 0)
    model.addConstr(10 * x0 + 5 * x1 + 8 * x2 <= 76)  # upper bound on digestive support
    model.addConstr(2 * x0 + 20 * x1 + 4 * x2 <= 120)  # upper bound on immune support

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B7: {x0.varValue}")
        print(f"Milligrams of vitamin B5: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
