
import gurobi as gp

def create_model():
    model = gp.Model()

    oreos = model.addVar(name="oreos", lb=0)
    hamburgers = model.addVar(name="hamburgers", lb=0)
    bananas = model.addVar(name="bananas", lb=0)
    blueberry_pies = model.addVar(name="blueberry_pies", lb=0)
    kiwis = model.addVar(name="kiwis", lb=0)
    oranges = model.addVar(name="oranges", lb=0)
    ravioli = model.addVar(name="ravioli", lb=0)
    chicken_drumsticks = model.addVar(name="chicken_drumsticks", lb=0)

    obj = 2.02 * oreos + 2.49 * hamburgers + 3.21 * bananas + 9.61 * blueberry_pies + 8.59 * kiwis + 1.08 * oranges + 2.35 * ravioli + 6.31 * chicken_drumsticks
    model.setObjective(obj, gp.GRB.MINIMIZE)

    # Iron constraints
    model.addConstr(3 * oreos + 4 * hamburgers + 2 * bananas + 9 * blueberry_pies + 6 * kiwis + 3 * oranges + 11 * ravioli + 4 * chicken_drumsticks <= 238)
    model.addConstr(3 * oreos + 3 * oranges >= 9)
    model.addConstr(6 * kiwis + 4 * chicken_drumsticks >= 15)

    # Carbohydrates constraints
    model.addConstr(10 * oreos + 7 * hamburgers + 6 * bananas + 6 * blueberry_pies + 6 * kiwis + 8 * oranges + 4 * ravioli + 11 * chicken_drumsticks <= 426)

    # Fiber constraints
    model.addConstr(oreos + 8 * hamburgers + 11 * bananas + 7 * blueberry_pies + 6 * kiwis + 5 * oranges + 10 * ravioli + 9 * chicken_drumsticks <= 385)

    # Other constraints...
    model.addConstr(-9 * bananas + 3 * blueberry_pies >= 0)
    model.addConstr(6 * hamburgers - 5 * ravioli >= 0)
    model.addConstr(-2 * oreos + 2 * bananas >= 0)

    model.optimize()

    if model.status == gp.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Oreos: ", oreos.varValue)
        print("Hamburgers: ", hamburgers.varValue)
        print("Bananas: ", bananas.varValue)
        print("Blueberry Pies: ", blueberry_pies.varValue)
        print("Kiwis: ", kiwis.varValue)
        print("Oranges: ", oranges.varValue)
        print("Ravioli: ", ravioli.varValue)
        print("Chicken Drumsticks: ", chicken_drumsticks.varValue)
    else:
        print("No solution found")

create_model()
