
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
lemons = m.addVar(vtype=gp.GRB.INTEGER, name="lemons")
peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.INTEGER, name="peanutbutter_sandwiches")
hamburgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hamburgers")
slices_of_pizza = m.addVar(vtype=gp.GRB.INTEGER, name="slices_of_pizza")

# Set objective function
m.setObjective(6.6 * lemons + 7.81 * peanutbutter_sandwiches + 2.96 * hamburgers + 9.02 * slices_of_pizza, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * lemons + 30 * peanutbutter_sandwiches + 9 * hamburgers + 19 * slices_of_pizza <= 696, "iron_upper_bound")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 9 * hamburgers + 11 * slices_of_pizza <= 295, "umami_upper_bound")

m.addConstr(30 * peanutbutter_sandwiches + 9 * hamburgers >= 141, "iron_constraint1")
m.addConstr(14 * lemons + 9 * hamburgers >= 102, "iron_constraint2")
m.addConstr(14 * lemons + 19 * slices_of_pizza >= 64, "iron_constraint3")
m.addConstr(14 * lemons + 9 * hamburgers + 19 * slices_of_pizza >= 122, "iron_constraint4")
m.addConstr(30 * peanutbutter_sandwiches + 9 * hamburgers + 19 * slices_of_pizza >= 122, "iron_constraint5")
m.addConstr(14 * lemons + 9 * hamburgers + 19 * slices_of_pizza >= 166, "iron_constraint6")
m.addConstr(30 * peanutbutter_sandwiches + 9 * hamburgers + 19 * slices_of_pizza >= 166, "iron_constraint7")

m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 9 * hamburgers >= 65, "umami_constraint1")
m.addConstr(30 * lemons + 9 * hamburgers + 11 * slices_of_pizza >= 65, "umami_constraint2")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 11 * slices_of_pizza >= 65, "umami_constraint3")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 9 * hamburgers >= 54, "umami_constraint4")
m.addConstr(30 * lemons + 9 * hamburgers + 11 * slices_of_pizza >= 54, "umami_constraint5")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 11 * slices_of_pizza >= 54, "umami_constraint6")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 9 * hamburgers >= 42, "umami_constraint7")
m.addConstr(30 * lemons + 9 * hamburgers + 11 * slices_of_pizza >= 42, "umami_constraint8")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 11 * slices_of_pizza >= 42, "umami_constraint9")


m.addConstr(14 * lemons + 9 * hamburgers <= 217, "iron_constraint8")
m.addConstr(14 * lemons + 30 * peanutbutter_sandwiches <= 401, "iron_constraint9")
m.addConstr(30 * peanutbutter_sandwiches + 9 * hamburgers <= 623, "iron_constraint10")
m.addConstr(14 * lemons + 30 * peanutbutter_sandwiches + 9 * hamburgers + 19 * slices_of_pizza <= 623, "iron_constraint11")

m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches <= 214, "umami_constraint10")
m.addConstr(19 * peanutbutter_sandwiches + 11 * slices_of_pizza <= 109, "umami_constraint11")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 11 * slices_of_pizza <= 94, "umami_constraint12")
m.addConstr(30 * lemons + 19 * peanutbutter_sandwiches + 9 * hamburgers + 11 * slices_of_pizza <= 94, "umami_constraint13")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

