
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x0 = m.addVar(name="lemons", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="peanutbutter sandwiches", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="hamburgers", vtype=gurobi.GRB.CONTINUOUS)
x3 = m.addVar(name="slices of pizza", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(6.6 * x0 + 7.81 * x1 + 2.96 * x2 + 9.02 * x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(14 * x0 + 30 * x1 + 9 * x2 + 19 * x3 <= 696)
m.addConstr(30 * x0 + 19 * x1 + 9 * x2 + 11 * x3 <= 295)
m.addConstr(30 * x1 + 9 * x2 >= 141)
m.addConstr(14 * x0 + 9 * x2 >= 102)
m.addConstr(14 * x0 + 19 * x3 >= 64)
m.addConstr(14 * x0 + 9 * x2 + 19 * x3 >= 122)
m.addConstr(30 * x1 + 9 * x2 + 19 * x3 >= 122)
m.addConstr(14 * x0 + 9 * x2 + 19 * x3 >= 166)
m.addConstr(30 * x1 + 9 * x2 + 19 * x3 >= 166)
m.addConstr(30 * x0 + 19 * x1 + 9 * x2 >= 65)
m.addConstr(30 * x0 + 9 * x2 + 11 * x3 >= 65)
m.addConstr(30 * x0 + 19 * x1 + 11 * x3 >= 65)
m.addConstr(30 * x0 + 19 * x1 + 9 * x2 >= 54)
m.addConstr(30 * x0 + 9 * x2 + 11 * x3 >= 54)
m.addConstr(30 * x0 + 19 * x1 + 11 * x3 >= 54)
m.addConstr(30 * x0 + 19 * x1 + 9 * x2 >= 42)
m.addConstr(30 * x0 + 9 * x2 + 11 * x3 >= 42)
m.addConstr(30 * x0 + 19 * x1 + 11 * x3 >= 42)
m.addConstr(14 * x0 + 9 * x2 <= 217)
m.addConstr(14 * x0 + 30 * x1 <= 401)
m.addConstr(30 * x1 + 9 * x2 <= 623)
m.addConstr(14 * x0 + 30 * x1 + 9 * x2 + 19 * x3 <= 623)
m.addConstr(30 * x0 + 19 * x1 <= 214)
m.addConstr(19 * x1 + 11 * x3 <= 109)
m.addConstr(30 * x0 + 19 * x1 + 11 * x3 <= 94)
m.addConstr(30 * x0 + 19 * x1 + 9 * x2 + 11 * x3 <= 94)

# Solve the model
m.optimize()

# Print the solution
print("Objective: ", m.objVal)
print("lemons: ", x0.varValue)
print("peanutbutter sandwiches: ", x1.varValue)
print("hamburgers: ", x2.varValue)
print("slices of pizza: ", x3.varValue)
