
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype='C', name="hours_worked_by_Jean")  # Continuous variable
    x1 = model.addVar(lb=0, vtype='C', name="hours_worked_by_Laura") # Continuous variable
    x2 = model.addVar(lb=0, vtype='C', name="hours_worked_by_Hank")  # Continuous variable


    # Set objective function
    model.setObjective(9*x0 + 7*x1 + 5*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(22*x0 + 20*x1 + 25*x2 >= 118, "paperwork_competence_total")
    model.addConstr(22*x1 + 23*x2 >= 41, "productivity_Laura_Hank")
    model.addConstr(14*x0 + 22*x1 >= 67, "productivity_Jean_Laura")
    model.addConstr(14*x0 + 23*x2 >= 48, "productivity_Jean_Hank")
    model.addConstr(14*x0 + 22*x1 + 23*x2 >= 65, "productivity_total")
    model.addConstr(22*x0 + 20*x1 <= 195, "paperwork_Jean_Laura")
    model.addConstr(22*x0 + 20*x1 + 25*x2 <= 195, "paperwork_total")
    model.addConstr(14*x0 + 23*x2 <= 152, "productivity_Jean_Hank_max")
    model.addConstr(22*x1 + 23*x2 <= 164, "productivity_Laura_Hank_max")
    model.addConstr(14*x0 + 22*x1 <= 143, "productivity_Jean_Laura_max")
    model.addConstr(14*x0 + 22*x1 + 23*x2 <= 143, "productivity_total_max")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Jean:', x0.x)
        print('Laura:', x1.x)
        print('Hank:', x2.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
