
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', lb=0)  # hours worked by Jean
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Laura
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Hank

    # Define the objective function
    model.setObjective(9 * x0 + 7 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(22 * x0 + 20 * x1 + 25 * x2 >= 118)
    model.addConstr(22 * x1 + 23 * x2 >= 41)
    model.addConstr(14 * x0 + 22 * x1 >= 67)
    model.addConstr(14 * x0 + 23 * x2 >= 48)
    model.addConstr(14 * x0 + 22 * x1 + 23 * x2 >= 65)
    model.addConstr(22 * x0 + 20 * x1 <= 195)
    model.addConstr(22 * x0 + 20 * x1 + 25 * x2 <= 423)
    model.addConstr(14 * x0 + 23 * x2 <= 152)
    model.addConstr(22 * x1 + 23 * x2 <= 164)
    model.addConstr(14 * x0 + 22 * x1 <= 143)
    model.addConstr(14 * x0 + 22 * x1 + 23 * x2 <= 143)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Hours worked by Jean: ', x0.varValue)
        print('Hours worked by Laura: ', x1.varValue)
        print('Hours worked by Hank: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
