
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    pathfinder_teams = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")
    recon_troops = m.addVar(vtype=GRB.INTEGER, name="recon_troops")


    # Set objective function
    m.setObjective(1.09 * pathfinder_teams + 7.7 * recon_troops, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(23 * pathfinder_teams + 10 * recon_troops >= 45, "offensive_capability")
    m.addConstr(21 * pathfinder_teams + 19 * recon_troops >= 65, "mobility_rating")
    m.addConstr(6 * pathfinder_teams - 2 * recon_troops >= 0, "pathfinder_recon_ratio")
    m.addConstr(23 * pathfinder_teams + 10 * recon_troops <= 188, "offensive_capability_upper")
    m.addConstr(21 * pathfinder_teams + 19 * recon_troops <= 141, "mobility_rating_upper")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Pathfinder Teams: {pathfinder_teams.x}")
        print(f"  Reconnaissance Troops: {recon_troops.x}")
        print(f"  Objective Value: {m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
