
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")
x1 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")

# Set objective function
m.setObjective(1.09*x0 + 7.7*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(23*x0 + 10*x1 >= 45, "offensive_capability_min")
m.addConstr(21*x0 + 19*x1 >= 65, "mobility_rating_min")
m.addConstr(6*x0 - 2*x1 >= 0, "pathfinder_reconnaissance_ratio")
m.addConstr(23*x0 + 10*x1 <= 188, "offensive_capability_max")
m.addConstr(21*x0 + 19*x1 <= 141, "mobility_rating_max")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Pathfinder teams:", x0.x)
    print("Reconnaissance troops:", x1.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found")
