
import gurobi as gp

# Create a new model
m = gp.Model("pathfinder_reconnaissance")

# Define the variables
x1 = m.addVar(name="pathfinder_teams", vtype=gp.GRB.INTEGER)  # pathfinder teams
x2 = m.addVar(name="reconnaissance_troops", vtype=gp.GRB.INTEGER)  # reconnaissance troops

# Define the objective function
m.setObjective(1.09 * x1 + 7.7 * x2, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(23 * x1 + 10 * x2 >= 45, name="offensive_capability_min")
m.addConstr(21 * x1 + 19 * x2 >= 65, name="mobility_min")
m.addConstr(6 * x1 - 2 * x2 >= 0, name="pathfinder_reconnaissance_ratio")
m.addConstr(23 * x1 + 10 * x2 <= 188, name="offensive_capability_max")
m.addConstr(21 * x1 + 19 * x2 <= 141, name="mobility_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Pathfinder teams: {x1.varValue}")
    print(f"Reconnaissance troops: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
