
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_k = m.addVar(lb=0, name="vitamin_k")  # milligrams of vitamin K
vitamin_b6 = m.addVar(lb=0, name="vitamin_b6") # milligrams of vitamin B6

# Set objective function
m.setObjective(3 * vitamin_k + 6 * vitamin_b6, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * vitamin_k + 8 * vitamin_b6 >= 28, "digestive_support_min")
m.addConstr(9 * vitamin_k + 20 * vitamin_b6 >= 13, "energy_stability_min")
m.addConstr(11 * vitamin_k + 17 * vitamin_b6 >= 29, "cognitive_performance_min")
m.addConstr(-7 * vitamin_k + 9 * vitamin_b6 >= 0, "vitamin_ratio")
m.addConstr(9 * vitamin_k + 8 * vitamin_b6 <= 57, "digestive_support_max")
m.addConstr(9 * vitamin_k + 20 * vitamin_b6 <= 49, "energy_stability_max")
m.addConstr(11 * vitamin_k + 17 * vitamin_b6 <= 59, "cognitive_performance_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Vitamin K:', vitamin_k.x)
    print('Vitamin B6:', vitamin_b6.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

