
from gurobipy import *

# Create a new model
m = Model("Vitamins_Optimization")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_K")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B6")

# Set the objective function
m.setObjective(3*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x1 + 8*x2 >= 28, "digestive_support_index_min")
m.addConstr(9*x1 + 20*x2 >= 13, "energy_stability_index_min")
m.addConstr(11*x1 + 17*x2 >= 29, "cognitive_performance_index_min")
m.addConstr(-7*x1 + 9*x2 >= 0, "vitamin_balance")
m.addConstr(9*x1 + 8*x2 <= 57, "digestive_support_index_max")
m.addConstr(9*x1 + 20*x2 <= 49, "energy_stability_index_max")
m.addConstr(11*x1 + 17*x2 <= 59, "cognitive_performance_index_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Milligrams of Vitamin K:", x1.x)
    print("Milligrams of Vitamin B6:", x2.x)
    print("Objective Function Value:", m.objVal)
else:
    print("No optimal solution found")
