
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x1 = m.addVar(name="milligrams of vitamin K", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="milligrams of vitamin B6", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
m.setObjective(3*x1 + 6*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(9 >= 9)
m.addConstr(9 >= 9)
m.addConstr(11 >= 11)
m.addConstr(8 >= 8)
m.addConstr(20 >= 20)
m.addConstr(17 >= 17)
m.addConstr(9 + 8 >= 28)
m.addConstr(9 + 20 >= 13)
m.addConstr(11 + 17 >= 29)
m.addConstr(-7*x1 + 9*x2 >= 0)
m.addConstr(9 + 8 <= 57)
m.addConstr(9 + 20 <= 49)
m.addConstr(11 + 17 <= 59)

# Optimize
m.optimize()

print(m.status)
if m.status == gurobi.GRB.INFEASIBLE:
    print("The problem is infeasible")
