
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x = m.addVars(4, name=["CBRN", "Artillery", "Water", "Medical"], vtype=gp.GRB.INTEGER)

    # Set objective function
    m.setObjective(4*x[0]**2 + 7*x[0]*x[1] + 9*x[0]*x[2] + 7*x[0]*x[3] + 3*x[1]**2 + 2*x[1]*x[2] + 8*x[1]*x[3] + 5*x[2]*x[3] + 5*x[3]**2 + 3*x[0] + x[2], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3*x[0] + 2*x[1] + 5*x[2] + 7*x[3] <= 117, "logistics_footprint")
    m.addConstr(6*x[0] + x[1] + 6*x[2] + 6*x[3] <= 107, "fun_factor")
    m.addConstr(5*x[2] + 7*x[3] >= 17, "water_medical_min_footprint")
    m.addConstr((3*x[0])**2 + (5*x[2])**2 >= 23, "cbrn_water_min_footprint_sq")
    m.addConstr(3*x[0] + 2*x[1] >= 11, "cbrn_art_min_footprint")
    m.addConstr(2*x[1] + 5*x[2] >= 19, "art_water_min_footprint")
    m.addConstr(3*x[0] + 2*x[1] + 5*x[2] + 7*x[3] >= 19, "total_min_footprint")
    m.addConstr(6*x[0] + x[1] >= 14, "cbrn_art_min_fun")
    m.addConstr(6*x[2] + 6*x[3] >= 20, "water_medical_min_fun")
    m.addConstr(6*x[0] + x[1] + 6*x[2] + 6*x[3] >= 20, "total_min_fun")
    m.addConstr(3*x[0] + 2*x[1] <= 106, "cbrn_art_max_footprint")
    m.addConstr((2*x[1])**2 + (7*x[3])**2 <= 97, "art_medical_max_footprint_sq")
    m.addConstr((2*x[1])**2 + (5*x[2])**2 <= 59, "art_water_max_footprint_sq")
    m.addConstr(3*x[0] + 5*x[2] + 7*x[3] <= 101, "cbrn_water_medical_max_footprint")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Objective Value: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GrorbiError as e:
    print(f'Error code {e.errno}: {e.message}')
except AttributeError:
    print('Encountered an attribute error')
