
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="artillery_batteries", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="water_purification_units", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="medical_platoons", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(4*x0**2 + 7*x0*x1 + 9*x0*x2 + 7*x0*x3 + 3*x1**2 + 2*x1*x2 + 8*x1*x3 + 5*x2*x3 + 5*x3**2 + 3*x0 + x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(3*x0 <= 117)
m.addConstr(6*x0 <= 107)
m.addConstr(2*x1 <= 117)
m.addConstr(x1 <= 107)
m.addConstr(5*x2 <= 117)
m.addConstr(6*x2 <= 107)
m.addConstr(7*x3 <= 117)
m.addConstr(6*x3 <= 107)
m.addConstr(5*x2 + 7*x3 >= 17)
m.addConstr(3*x0**2 + 5*x2**2 >= 23)
m.addConstr(3*x0 + 2*x1 >= 11)
m.addConstr(2*x1 + 5*x2 >= 19)
m.addConstr(3*x0 + 2*x1 + 5*x2 + 7*x3 >= 19)
m.addConstr(6*x0 + x1 >= 14)
m.addConstr(6*x2 + 6*x3 >= 20)
m.addConstr(6*x0 + x1 + 6*x2 + 6*x3 >= 20)
m.addConstr(3*x0 + 2*x1 <= 106)
m.addConstr(2*x1**2 + 7*x3**2 <= 97)
m.addConstr(2*x1**2 + 5*x2**2 <= 59)
m.addConstr(3*x0 + 5*x2 + 7*x3 <= 101)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("CBRN platoons: ", x0.varValue)
    print("artillery batteries: ", x1.varValue)
    print("water purification units: ", x2.varValue)
    print("medical platoons: ", x3.varValue)
else:
    print("The model is infeasible")
