
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_A")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B4")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B12")


    # Set objective function
    m.setObjective(6.67 * x0 + 8.69 * x1 + 9.29 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * x0 + 10 * x1 + 1 * x2 <= 160, "kidney_support_total")  # Corrected constraint
    m.addConstr(14 * x0 + 4 * x1 + 13 * x2 <= 109, "cognitive_performance_total") # Corrected constraint
    m.addConstr(7 * x1 - 8 * x2 >= 0, "B4_B12_relation")
    m.addConstr(10 * x1 + 1 * x2 <= 139, "kidney_support_B4_B12")
    m.addConstr(3 * x0 + 1 * x2 <= 127, "kidney_support_A_B12")
    m.addConstr(3 * x0 + 10 * x1 <= 96, "kidney_support_A_B4")
    m.addConstr(3 * x0 + 10 * x1 + 1 * x2 <= 96, "kidney_support_A_B4_B12")
    m.addConstr(14 * x0 + 4 * x1 <= 53, "cognitive_performance_A_B4")
    m.addConstr(4 * x1 + 13 * x2 <= 80, "cognitive_performance_B4_B12")
    m.addConstr(14 * x0 + 4 * x1 + 13 * x2 <= 70, "cognitive_performance_A_B4_B12_1")
    m.addConstr(14 * x0 + 4 * x1 + 13 * x2 <= 70, "cognitive_performance_A_B4_B12_2")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
