
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin A
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B4
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B12

    # Define the objective function
    model.setObjective(6.67 * x0 + 8.69 * x1 + 9.29 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x0 <= 160)  
    model.addConstr(14 * x0 <= 109)  
    model.addConstr(10 * x1 <= 160)  
    model.addConstr(4 * x1 <= 109)  
    model.addConstr(x2 <= 160)  
    model.addConstr(13 * x2 <= 109)  
    model.addConstr(7 * x1 - 8 * x2 >= 0)  
    model.addConstr(10 * x1 + x2 <= 139)  
    model.addConstr(3 * x0 + x2 <= 127)  
    model.addConstr(3 * x0 + 10 * x1 <= 96)  
    model.addConstr(3 * x0 + 10 * x1 + x2 <= 96)  
    model.addConstr(14 * x0 + 4 * x1 <= 53)  
    model.addConstr(4 * x1 + 13 * x2 <= 80)  
    model.addConstr(14 * x0 + 4 * x1 + 13 * x2 <= 70)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin A: {x0.varValue}")
        print(f"Milligrams of vitamin B4: {x1.varValue}")
        print(f"Milligrams of vitamin B12: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
