
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Hank
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Jean
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Mary

    # Define the objective function
    model.setObjective(6.35 * x1 + 4.82 * x2 + 7.75 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5.9 * x1 + 20.41 * x3 >= 87)
    model.addConstr(5.9 * x1 + 19.39 * x2 >= 61)
    model.addConstr(5.9 * x1 + 19.39 * x2 + 20.41 * x3 >= 61)
    model.addConstr(-10 * x1 + 6 * x3 >= 0)
    model.addConstr(7 * x2 - 9 * x3 >= 0)
    model.addConstr(5.9 * x1 + 19.39 * x2 <= 175)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Hank: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
        print("Hours worked by Mary: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
