
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0.0, vtype=[GRB.CONTINUOUS, GRB.INTEGER, GRB.CONTINUOUS, GRB.INTEGER, GRB.CONTINUOUS], name=["Jean", "Mary", "Bobby", "Dale", "Ringo"])


# Set objective function
m.setObjective(1*x[0] + 9*x[1] + 3*x[2] + 7*x[3] + 2*x[4], GRB.MAXIMIZE)

# Add constraints

# Computer competence rating constraints
m.addConstr(18*x[1] + 21*x[3] + 5*x[4] >= 34)
m.addConstr(3*x[0] + 18*x[2] + 5*x[4] >= 34)
m.addConstr(3*x[0] + 18*x[2] + 21*x[3] >= 34)
m.addConstr(3*x[0] + 18*x[1] + 18*x[2] >= 34)
m.addConstr(3*x[0] + 18*x[1] + 21*x[3] >= 34)


# ... (rest of the constraints from the JSON "constraints" section)
m.addConstr(18*x[1] + 18*x[2] <= 214)
m.addConstr(18*x[2] + 5*x[4] <= 70)
m.addConstr(3*x[0] + 18*x[1] <= 88)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

