
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Jean", lb=0)  # No upper bound specified
x1 = m.addVar(name="hours_worked_by_Mary", lb=0, integrality=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Bobby", lb=0)  
x3 = m.addVar(name="hours_worked_by_Dale", lb=0, integrality=gp.GRB.INTEGER)
x4 = m.addVar(name="hours_worked_by_Ringo", lb=0)

# Objective function
m.setObjective(1*x0 + 9*x1 + 3*x2 + 7*x3 + 2*x4, gp.GRB.MAXIMIZE)

# Constraints
# Computer competence rating constraints
m.addConstr(18*x1 + 21*x3 + 5*x4 >= 34)
m.addConstr(3*x0 + 18*x2 + 5*x4 >= 34)
m.addConstr(21*x0 + 18*x2 + 21*x3 >= 34)
m.addConstr(3*x0 + 18*x1 + 18*x2 >= 34)
m.addConstr(3*x0 + 18*x1 + 21*x3 >= 34)
m.addConstr(18*x1 + 21*x3 + 5*x4 >= 38)
m.addConstr(3*x0 + 18*x2 + 5*x4 >= 38)
m.addConstr(21*x0 + 18*x2 + 21*x3 >= 38)
m.addConstr(3*x0 + 18*x1 + 18*x2 >= 38)
m.addConstr(3*x0 + 18*x1 + 21*x3 >= 38)
m.addConstr(18*x1 + 21*x3 + 5*x4 >= 39)
m.addConstr(3*x0 + 18*x2 + 5*x4 >= 39)
m.addConstr(21*x0 + 18*x2 + 21*x3 >= 39)
m.addConstr(3*x0 + 18*x1 + 18*x2 >= 39)
m.addConstr(3*x0 + 18*x1 + 21*x3 >= 39)

# Productivity rating constraints
m.addConstr(x0 + 21*x1 >= 21)
m.addConstr(2*x3 + 2*x4 >= 15)
m.addConstr(x0 + 2*x4 >= 36)
m.addConstr(21*x1 + 2*x4 >= 29)
m.addConstr(21*x1 + 20*x2 >= 15)
m.addConstr(20*x2 + 2*x3 >= 12)
m.addConstr(21*x1 + 2*x3 >= 33)
m.addConstr(x0 + 2*x3 >= 17)
m.addConstr(x0 + 21*x1 + 2*x3 >= 33)

# Dollar cost per hour constraints
m.addConstr(8*x0 + 13*x1 + 5*x3 >= 42)
m.addConstr(8*x0 + 5*x3 + 7*x4 >= 42)

# Work quality rating constraints
m.addConstr(12*x0 + 14*x1 >= 42)
m.addConstr(12*x0 + 10*x4 >= 31)
m.addConstr(21*x2 + 22*x3 >= 27)
m.addConstr(14*x1 + 22*x3 >= 15)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Jean: ", x0.varValue)
    print("Hours worked by Mary: ", x1.varValue)
    print("Hours worked by Bobby: ", x2.varValue)
    print("Hours worked by Dale: ", x3.varValue)
    print("Hours worked by Ringo: ", x4.varValue)
else:
    print("No optimal solution found")
