
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by John
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Peggy
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Mary
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")  # hours worked by Bill


# Set objective function
m.setObjective(x0**2 + 9*x0*x1 + 3*x0*x2 + 8*x0*x3 + 8*x1**2 + 4*x1*x2 + 9*x1*x3 + 4*x2**2 + 6*x2*x3 + 4*x3**2 + 9*x0 + 9*x1 + 7*x2 + 7*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9.81*x0 + 8.75*x1 >= 13)
m.addConstr(8.75*x1 + 1.26*x2 >= 12)
m.addConstr(1.26*x2 + 0.87*x3 >= 19)
m.addConstr(9.81*x0 + 1.26*x2 >= 31)
m.addConstr(9.81*x0 + 0.87*x3 >= 20)
m.addConstr(9.81*x0 + 1.26*x2 + 0.87*x3 >= 25)
m.addConstr(9.81*x0 + 8.75*x1 + 1.26*x2 + 0.87*x3 >= 25)
m.addConstr(9.41*x0 + 0.53*x3 >= 10)
m.addConstr(9.41*x0 + 3.47*x1 >= 6)
m.addConstr(9.41*x0 + 9.45*x2 >= 12)
m.addConstr(3.47*x1**2 + 0.53*x3**2 >= 14)
m.addConstr(9.41*x0 + 3.47*x1 + 9.45*x2 + 0.53*x3 >= 14)
m.addConstr(7.21*x0**2 + 0.23*x3**2 >= 18)
m.addConstr(7.21*x0 + 1.75*x1 >= 11)
m.addConstr(1.75*x1 + 0.23*x3 >= 13)
m.addConstr(7.21*x0**2 + 1.75*x1**2 + 1.49*x2**2 >= 18)
m.addConstr(1.75*x1 + 1.49*x2 + 0.23*x3 >= 18)
m.addConstr(7.21*x0 + 1.75*x1 + 1.49*x2 >= 15)
m.addConstr(1.75*x1 + 1.49*x2 + 0.23*x3 >= 15)
m.addConstr(7.21*x0 + 1.75*x1 + 1.49*x2 + 0.23*x3 >= 15)
m.addConstr(-2*x0 + 3*x2 >= 0)
m.addConstr(8.75*x1 + 1.26*x2 <= 66)
m.addConstr(9.45*x2 + 0.53*x3 <= 66)
m.addConstr(9.41*x0 + 3.47*x1 <= 22)
m.addConstr(9.41*x0**2 + 3.47*x1**2 + 0.53*x3**2 <= 38)
m.addConstr(3.47*x1 + 9.45*x2 + 0.53*x3 <= 49)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

