
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by John
x1 = m.addVar(name="x1", lb=0)  # hours worked by Peggy
x2 = m.addVar(name="x2", lb=0)  # hours worked by Mary
x3 = m.addVar(name="x3", lb=0)  # hours worked by Bill

# Define the objective function
m.setObjective(1*x0**2 + 9*x0*x1 + 3*x0*x2 + 8*x0*x3 + 8*x1**2 + 4*x1*x2 + 9*x1*x3 + 4*x2**2 + 6*x2*x3 + 4*x3**2 + 9*x0 + 9*x1 + 7*x2 + 7*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9.81*x0 <= 132)
m.addConstr(9.41*x0 <= 76)
m.addConstr(7.21*x0 <= 80)
m.addConstr(8.75*x1 <= 132)
m.addConstr(3.47*x1 <= 76)
m.addConstr(1.75*x1 <= 80)
m.addConstr(1.26*x2 <= 132)
m.addConstr(9.45*x2 <= 76)
m.addConstr(1.49*x2 <= 80)
m.addConstr(0.87*x3 <= 132)
m.addConstr(0.53*x3 <= 76)
m.addConstr(0.23*x3 <= 80)
m.addConstr(9.81*x0 + 8.75*x1 >= 13)
m.addConstr(3.47*x1 + 1.26*x2 >= 12)
m.addConstr(1.26*x2 + 0.87*x3 >= 19)
m.addConstr(9.81*x0 + 1.26*x2 >= 31)
m.addConstr(9.81*x0 + 0.87*x3 >= 20)
m.addConstr(9.81*x0 + 1.26*x2 + 0.87*x3 >= 25)
m.addConstr(9.81*x0 + 8.75*x1 + 1.26*x2 + 0.87*x3 >= 25)
m.addConstr(9.41*x0 + 0.53*x3 >= 10)
m.addConstr(9.41*x0 + 3.47*x1 >= 6)
m.addConstr(9.41*x0 + 9.45*x2 >= 12)
m.addConstr(3.47**2*x1**2 + 0.53**2*x3**2 >= 14)
m.addConstr(9.41*x0 + 3.47*x1 + 9.45*x2 + 0.53*x3 >= 14)
m.addConstr(7.21**2*x0**2 + 0.23**2*x3**2 >= 18)
m.addConstr(7.21*x0 + 1.75*x1 >= 11)
m.addConstr(1.75*x1 + 0.23*x3 >= 13)
m.addConstr(7.21**2*x0**2 + 1.75**2*x1**2 + 1.49**2*x2**2 >= 18)
m.addConstr(1.75*x1 + 1.49*x2 + 0.23*x3 >= 18)
m.addConstr(7.21*x0 + 1.75*x1 + 1.49*x2 >= 15)
m.addConstr(1.75*x1 + 1.49*x2 + 0.23*x3 >= 15)
m.addConstr(7.21*x0 + 1.75*x1 + 1.49*x2 + 0.23*x3 >= 15)
m.addConstr(-2*x0 + 3*x2 >= 0)
m.addConstr(8.75*x1 + 1.26*x2 <= 66)
m.addConstr(9.45*x2 + 0.53*x3 <= 66)
m.addConstr(9.41*x0 + 3.47*x1 <= 22)
m.addConstr(9.41**2*x0**2 + 3.47**2*x1**2 + 0.53**2*x3**2 <= 38)
m.addConstr(3.47*x1 + 9.45*x2 + 0.53*x3 <= 49)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by John: ", x0.varValue)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by Mary: ", x2.varValue)
    print("Hours worked by Bill: ", x3.varValue)
else:
    print("No optimal solution found.")
