
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    paul_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")
    dale_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")


    # Set objective function
    model.setObjective(3.56 * paul_hours + 9.21 * dale_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.44 * paul_hours + 0.93 * dale_hours >= 21, "paperwork_competence_min")
    model.addConstr(0.47 * paul_hours + 0.89 * dale_hours >= 12, "dollar_cost_min")
    model.addConstr(8 * paul_hours - 5 * dale_hours >= 0, "paul_dale_ratio")
    model.addConstr(0.44 * paul_hours + 0.93 * dale_hours <= 38, "paperwork_competence_max")
    model.addConstr(0.47 * paul_hours + 0.89 * dale_hours <= 21, "dollar_cost_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Paul: {paul_hours.x}")
        print(f"Hours worked by Dale: {dale_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
