
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_Paul")
x2 = m.addVar(lb=0, name="hours_worked_by_Dale")

# Set the objective function
m.setObjective(3.56*x1 + 9.21*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.44*x1 + 0.93*x2 >= 21, "paperwork_competence_rating")
m.addConstr(0.47*x1 + 0.89*x2 >= 12, "dollar_cost_per_hour_min")
m.addConstr(8*x1 - 5*x2 >= 0, "linear_constraint")
m.addConstr(0.44*x1 + 0.93*x2 <= 38, "max_paperwork_competence_rating")
m.addConstr(0.47*x1 + 0.89*x2 <= 21, "max_dollar_cost_per_hour")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Hours worked by Dale: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
