
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Paul", lb=0)  # Lower bound is 0, assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_Dale", lb=0)  # Lower bound is 0, assuming hours cannot be negative

    # Objective function: maximize 3.56*x1 + 9.21*x2
    model.setObjective(3.56 * x1 + 9.21 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(0.44 * x1 + 0.93 * x2 >= 21, name="paperwork_competence_rating_min")
    model.addConstr(0.47 * x1 + 0.89 * x2 >= 12, name="dollar_cost_per_hour_min")
    model.addConstr(8 * x1 - 5 * x2 >= 0, name="hourly_work_constraint")
    model.addConstr(0.44 * x1 + 0.93 * x2 <= 38, name="paperwork_competence_rating_max")
    model.addConstr(0.47 * x1 + 0.89 * x2 <= 21, name="dollar_cost_per_hour_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Paul: {x1.varValue}")
        print(f"Hours worked by Dale: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
