
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
paul = m.addVar(vtype=gp.GRB.INTEGER, name="paul")
dale = m.addVar(vtype=gp.GRB.INTEGER, name="dale")
john = m.addVar(vtype=gp.GRB.CONTINUOUS, name="john")
hank = m.addVar(vtype=gp.GRB.INTEGER, name="hank")
mary = m.addVar(vtype=gp.GRB.INTEGER, name="mary")


# Set objective function
m.setObjective(1.7 * paul + 4.03 * dale + 4.91 * john + 3.04 * hank + 1.33 * mary, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * john + 14 * mary >= 20)
m.addConstr(12 * dale + 6 * john + 2 * hank >= 32)
m.addConstr(6 * john + 2 * hank + 14 * mary >= 32)
m.addConstr(11 * paul + 12 * dale + 6 * john >= 32)
m.addConstr(11 * paul + 6 * john + 14 * mary >= 32)
m.addConstr(12 * dale + 6 * john + 14 * mary >= 32)
m.addConstr(11 * paul + 12 * dale + 2 * hank >= 32)

# ... (rest of the constraints from the JSON "constraints" section)

m.addConstr(9 * paul + 3 * mary <= 60)
m.addConstr(6 * hank + 3 * mary <= 52)
m.addConstr(9 * paul + 4 * dale + 13 * john + 6 * hank + 3 * mary <= 52)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

