
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # hours worked by Paul
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Dale
    x2 = model.addVar(name='x2')  # hours worked by John
    x3 = model.addVar(name='x3', vtype=gurobi.GRB.INTEGER)  # hours worked by Hank
    x4 = model.addVar(name='x4', vtype=gurobi.GRB.INTEGER)  # hours worked by Mary

    # Objective function
    model.setObjective(1.7*x0 + 4.03*x1 + 4.91*x2 + 3.04*x3 + 1.33*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(11*x0 <= 312)
    model.addConstr(12*x0 <= 323)
    model.addConstr(9*x0 <= 117)

    model.addConstr(12*x1 <= 312)
    model.addConstr(18*x1 <= 323)
    model.addConstr(4*x1 <= 117)

    model.addConstr(6*x2 <= 312)
    model.addConstr(16*x2 <= 323)
    model.addConstr(13*x2 <= 117)

    model.addConstr(2*x3 <= 312)
    model.addConstr(19*x3 <= 323)
    model.addConstr(6*x3 <= 117)

    model.addConstr(14*x4 <= 312)
    model.addConstr(10*x4 <= 323)
    model.addConstr(3*x4 <= 117)

    model.addConstr(6*x2 + 14*x4 >= 20)
    model.addConstr(12*x1 + 6*x2 + 2*x3 >= 32)
    model.addConstr(6*x2 + 2*x3 + 14*x4 >= 32)
    model.addConstr(11*x0 + 12*x1 + 6*x2 >= 32)
    model.addConstr(11*x0 + 6*x2 + 14*x4 >= 32)
    model.addConstr(12*x1 + 6*x2 + 14*x4 >= 32)
    model.addConstr(11*x0 + 12*x1 + 2*x3 >= 32)

    # ... add all constraints similarly

    model.addConstr(11*x0 + 6*x2 <= 251)
    model.addConstr(11*x0 + 10*x4 <= 118)
    model.addConstr(12*x1 + 19*x3 <= 217)
    model.addConstr(11*x0 + 12*x1 <= 140)
    model.addConstr(16*x2 + 19*x3 <= 138)
    model.addConstr(16*x2 + 10*x4 <= 83)
    model.addConstr(18*x1 + 16*x2 <= 146)
    model.addConstr(11*x0 + 12*x1 + 16*x2 + 19*x3 + 10*x4 <= 146)

    model.addConstr(4*x1 + 6*x3 <= 27)
    model.addConstr(9*x0 + 3*x4 <= 60)
    model.addConstr(6*x3 + 3*x4 <= 52)
    model.addConstr(9*x0 + 12*x1 + 13*x2 + 6*x3 + 3*x4 <= 52)

    model.addConstr(12*x0 + 6*x2 <= 310)
    model.addConstr(6*x2 + 2*x3 <= 135)
    model.addConstr(11*x0 + 14*x4 <= 263)
    model.addConstr(12*x1 + 14*x4 <= 295)
    model.addConstr(11*x0 + 2*x3 <= 159)
    model.addConstr(11*x0 + 12*x1 + 6*x2 <= 86)
    model.addConstr(11*x0 + 12*x1 + 14*x4 <= 258)
    model.addConstr(6*x2 + 2*x3 + 14*x4 <= 131)
    model.addConstr(12*x1 + 6*x2 + 14*x4 <= 305)
    model.addConstr(12*x1 + 2*x3 + 14*x4 <= 213)
    model.addConstr(11*x0 + 12*x1 + 6*x2 + 2*x3 + 14*x4 <= 213)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
