
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
ringo = m.addVar(vtype=GRB.INTEGER, name="ringo")
laura = m.addVar(vtype=GRB.INTEGER, name="laura")
george = m.addVar(vtype=GRB.INTEGER, name="george")
hank = m.addVar(vtype=GRB.INTEGER, name="hank")
bill = m.addVar(vtype=GRB.INTEGER, name="bill")
bobby = m.addVar(vtype=GRB.INTEGER, name="bobby")


# Set objective
obj = 4.95*ringo**2 + 7.37*ringo*laura + 9.41*ringo*george + 9.38*ringo*hank + 7.29*ringo*bobby + 2.03*laura**2 + 4.48*laura*george + 3.43*laura*hank + 5.16*laura*bill + 5.25*laura*bobby + 9.99*george*hank + 7.32*george*bill + 1.82*george*bobby + 5.33*hank**2 + 7.18*bill**2 + 4.59*bill*bobby + 9.6*bobby**2 + 1.04*ringo + 1.83*laura + 4.82*george + 2.5*hank + 8.75*bill

m.setObjective(obj, GRB.MAXIMIZE)

# Add constraints

# Resource constraint
m.addConstr(4*ringo + 24*laura + 10*george + 27*hank + 7*bill + 28*bobby <= 434, "r0")


# Competence rating constraints (simplified and combined where possible)
m.addConstr(24*laura + 27*hank + 28*bobby >= 37, "c1")
m.addConstr(24*laura + 27*hank + 7*bill >= 37, "c2")
m.addConstr(24*laura + 10*george + 27*hank >= 37, "c3")
m.addConstr(27*hank + 7*bill + 28*bobby >= 37, "c4")
m.addConstr(4*ringo + 27*hank + 28*bobby >= 37, "c5")
m.addConstr(10*george + 7*bill + 28*bobby >= 37, "c6")
m.addConstr(24*laura + 10*george + 28*bobby >= 37, "c7")
m.addConstr(4*ringo + 24*laura + 7*bill >= 37, "c8")
m.addConstr(24*laura + 10*george + 7*bill >= 37, "c9")
m.addConstr(10*george + 27*hank + 7*bill >= 37, "c10")
m.addConstr(10*george + 27*hank + 28*bobby >= 37, "c11")

# Additional constraints
m.addConstr(-10*ringo + 10*laura >= 0, "c12")
m.addConstr(24*laura**2 + 28*bobby**2 <= 81, "c13")
m.addConstr(27*hank + 28*bobby <= 427, "c14")
m.addConstr(4*ringo + 24*laura <= 81, "c15")
m.addConstr(4*ringo**2 + 27*hank**2 <= 342, "c16")
m.addConstr(24*laura**2 + 7*bill**2 + 28*bobby**2 <= 149, "c17")
m.addConstr(4*ringo + 10*george + 7*bill <= 137, "c18")
m.addConstr(4*ringo + 24*laura + 10*george <= 397, "c19")
m.addConstr(4*ringo + 10*george + 27*hank <= 152, "c20")
m.addConstr(24*laura + 27*hank + 7*bill <= 159, "c21")
m.addConstr(24*laura + 10*george + 27*hank <= 340, "c22")
m.addConstr(24*laura + 10*george + 7*bill <= 339, "c23")
m.addConstr(4*ringo + 24*laura + 27*hank <= 176, "c24")
m.addConstr(10*george**2 + 7*bill**2 + 28*bobby**2 <= 344, "c25")
m.addConstr(24*laura**2 + 10*george**2 + 28*bobby**2 <= 168, "c26")
m.addConstr(4*ringo**2 + 24*laura**2 + 7*bill**2 <= 242, "c27")
m.addConstr(4*ringo + 7*bill + 28*bobby <= 191, "c28")
m.addConstr(4*ringo + 24*laura + 10*george + 27*hank + 7*bill + 28*bobby <= 191, "c29")



# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

