
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
pickles = model.addVar(vtype=GRB.INTEGER, name="pickles")
apples = model.addVar(vtype=GRB.INTEGER, name="apples")
tomatoes = model.addVar(vtype=GRB.INTEGER, name="tomatoes")
oreos = model.addVar(vtype=GRB.INTEGER, name="oreos")
rotisserie_chickens = model.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
knishes = model.addVar(vtype=GRB.INTEGER, name="knishes")
potatoes = model.addVar(vtype=GRB.CONTINUOUS, name="potatoes")


# Set objective function
model.setObjective(7.0 * pickles + 9.18 * apples + 4.04 * tomatoes + 8.52 * oreos + 8.33 * rotisserie_chickens + 6.31 * knishes + 7.96 * potatoes, GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * pickles + 2 * rotisserie_chickens >= 27)
model.addConstr(8 * knishes + 7 * potatoes >= 31)
model.addConstr(6 * apples + 3 * tomatoes >= 30)
model.addConstr(6 * apples + 8 * knishes >= 14)
model.addConstr(3 * tomatoes + 2 * rotisserie_chickens >= 13)
model.addConstr(8 * pickles + 6 * apples + 3 * tomatoes + 1 * oreos + 2 * rotisserie_chickens + 8 * knishes + 7 * potatoes >= 13)
# ... (add all other constraints similarly)

# Resource constraints
r = {}
r[0] = {'upper_bound': 217, 'x0': 8, 'x1': 6, 'x2': 3, 'x3': 1, 'x4': 2, 'x5': 8, 'x6': 7}
r[1] = {'upper_bound': 171, 'x0': 6, 'x1': 7, 'x2': 8, 'x3': 6, 'x4': 4, 'x5': 1, 'x6': 5}
r[2] = {'upper_bound': 116, 'x0': 1, 'x1': 3, 'x2': 6, 'x3': 6, 'x4': 7, 'x5': 2, 'x6': 8}

model.addConstr(r[0]['x0'] * pickles + r[0]['x1'] * apples + r[0]['x2'] * tomatoes + r[0]['x3'] * oreos + r[0]['x4'] * rotisserie_chickens + r[0]['x5'] * knishes + r[0]['x6'] * potatoes <= r[0]['upper_bound'])
model.addConstr(r[1]['x0'] * pickles + r[1]['x1'] * apples + r[1]['x2'] * tomatoes + r[1]['x3'] * oreos + r[1]['x4'] * rotisserie_chickens + r[1]['x5'] * knishes + r[1]['x6'] * potatoes <= r[1]['upper_bound'])
model.addConstr(r[2]['x0'] * pickles + r[2]['x1'] * apples + r[2]['x2'] * tomatoes + r[2]['x3'] * oreos + r[2]['x4'] * rotisserie_chickens + r[2]['x5'] * knishes + r[2]['x6'] * potatoes <= r[2]['upper_bound'])


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

