
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")


# Set objective
m.setObjective(4.87 * ringo + 3.0 * mary + 9.03 * jean + 7.73 * dale + 8.75 * john + 7.94 * bill, gp.GRB.MAXIMIZE)

# Add constraints

m.addConstr(7 * dale + 6 * john >= 18)
m.addConstr(11 * mary + 6 * dale >= 17)
m.addConstr(11 * mary + 6 * john >= 13)
m.addConstr(7 * ringo + 5 * jean >= 19)
m.addConstr(7 * ringo + 6 * dale >= 15)
m.addConstr(11 * mary + 9 * bill >= 9)
m.addConstr(6 * john + 9 * bill >= 8)
m.addConstr(6 * dale + 9 * bill >= 10)
m.addConstr(7 * ringo + 9 * bill >= 8)
m.addConstr(7 * ringo + 5 * jean + 6 * john >= 15)
m.addConstr(7 * ringo + 11 * mary + 9 * bill >= 15)
m.addConstr(7 * ringo + 6 * john + 9 * bill >= 15)
m.addConstr(7 * ringo + 5 * jean + 6 * john >= 16)
m.addConstr(7 * ringo + 11 * mary + 9 * bill >= 16)
m.addConstr(7 * ringo + 6 * john + 9 * bill >= 16)
m.addConstr(7 * ringo + 5 * jean + 6 * john >= 20)
m.addConstr(7 * ringo + 11 * mary + 9 * bill >= 20)
m.addConstr(7 * ringo + 6 * john + 9 * bill >= 20)
m.addConstr(5 * ringo + 9 * mary >= 25)
m.addConstr(9 * mary + 8 * bill >= 14)
m.addConstr(9 * jean + 10 * john >= 18)


m.addConstr(11 * mary + 6 * dale <= 33)
m.addConstr(11 * mary + 6 * john <= 50)
m.addConstr(7 * ringo + 6 * dale + 6 * john <= 87)
m.addConstr(7 * ringo + 5 * jean + 6 * john <= 55)
m.addConstr(7 * ringo + 11 * mary + 6 * dale <= 119)
m.addConstr(7 * ringo + 11 * mary + 5 * jean <= 116)
m.addConstr(11 * mary + 6 * dale + 6 * john <= 67)
m.addConstr(7 * ringo + 6 * john + 9 * bill <= 91)
m.addConstr(5 * jean + 6 * dale + 6 * john <= 30)
m.addConstr(5 * jean + 6 * dale + 9 * bill <= 91)
m.addConstr(7 * ringo + 5 * jean + 9 * bill <= 52)
m.addConstr(11 * mary + 5 * jean + 9 * bill <= 65)
m.addConstr(6 * dale + 6 * john + 9 * bill <= 110)
m.addConstr(11 * mary + 6 * dale + 9 * bill <= 21)
m.addConstr(7 * ringo + 11 * mary + 5 * jean + 6 * dale + 6 * john + 9 * bill <= 21)



# Optimize model
m.optimize()

#print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
